package gov.va.genisis2.ts.common.dto;

import java.io.Serializable;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import gov.va.genisis2.ts.objectmapper.EscapeHtmlSerializer;

/**
 * Data Transfer Object (DTO) to transfer details of concepts mappings
 * 
 * @author Prasad Thummalapalli
 *
 */
@JsonRootName(value = "conceptMapping")
@JsonIgnoreProperties({ "id" })
public class ConceptMappingDTO implements Serializable {

	private static final long serialVersionUID = 3513102680829255433L;

	private int id;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String conceptUri;
	
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	@JsonProperty("conceptName")
	private String term;
	
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String definition;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String algorithm;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String validation;
	
	@JsonProperty("dataElements")
	private Set<ConceptMappingDataElementDTO> conceptMappingDataElements;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the conceptUri
	 */
	public String getConceptUri() {
		return conceptUri;
	}

	/**
	 * @param conceptUri
	 *            the conceptUri to set
	 */
	public void setConceptUri(String conceptUri) {
		this.conceptUri = conceptUri;
	}

	/**
	 * @return the term
	 */
	public String getTerm() {
		return term;
	}

	/**
	 * @param term
	 *            the term to set
	 */
	public void setTerm(String term) {
		this.term = term;
	}

	/**
	 * @return the definition
	 */
	public String getDefinition() {
		return definition;
	}

	/**
	 * @param definition
	 *            the definition to set
	 */
	public void setDefinition(String definition) {
		this.definition = definition;
	}

	/**
	 * @return the algorithm
	 */
	public String getAlgorithm() {
		return algorithm;
	}

	/**
	 * @param algorithm
	 *            the algorithm to set
	 */
	public void setAlgorithm(String algorithm) {
		this.algorithm = algorithm;
	}

	/**
	 * @return the validation
	 */
	public String getValidation() {
		return validation;
	}

	/**
	 * @param validation
	 *            the validation to set
	 */
	public void setValidation(String validation) {
		this.validation = validation;
	}

	/**
	 * @return the conceptMappingDataElements
	 */
	public Set<ConceptMappingDataElementDTO> getConceptMappingDataElements() {
		return conceptMappingDataElements;
	}

	/**
	 * @param conceptMappingDataElements
	 *            the conceptMappingDataElements to set
	 */
	public void setConceptMappingDataElements(Set<ConceptMappingDataElementDTO> conceptMappingDataElements) {
		this.conceptMappingDataElements = conceptMappingDataElements;
	}
}
